<?xml version="1.0" encoding="WINDOWS-1251"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="WINDOWS-1251" indent="yes"/>
	<xsl:key name="Search" match="package/body/SimpleMedicalServices/Type_sms/Group/sms" use="@code"/>
	<xsl:key name="SearchMnn" match="package/body/MNNs/MNN" use="@code"/>
	<xsl:key name="SearchEx" match="package/body/ExpendableMaterialsGroups/ExpendableMaterialsGroup/ExpendableMaterials/ExpendableMaterial" use="@code"/>
	<xsl:template name="head" match="package">
		<table width="100%" border="1" col="2" bgcolor="#F8F8FF">
			<td width="20%" height="250px" valign="top">
				<table>
					<tr>
						<td>
							<button onclick="disp('SMS')" style="width:100x;height:25px">  </button>
							<div id="SMS" class="divStyle" hidden="true" align="left">
								<table border="0" bgcolor="#F5F5DC" align="left">
									<xsl:for-each select="body/SimpleMedicalServices/Type_sms">
										<xsl:variable name="Co" select="@code"/>
										<tr>
											<td>
												<b>---></b>
												<button onclick="Bmm('_{$Co}');Amm()" ondblclick="disp('_{$Co}')" style="width:100x;height:25px">
													<xsl:value-of select="@name"/>
												</button>
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</div>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dComplex');Amm();Cmm();Dmm()" ondblclick="disp('_dComplex')" style="width:100x;height:25px"> </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dStandart');Amm();Cmm();Dmm()" ondblclick="disp('_dStandart')" style="width:100x;height:25px"></button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dLpu');Amm();Cmm();Dmm()" ondblclick="disp('_dLpu')" style="width:100x;height:25px">  </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dSmo');Amm();Cmm();Dmm()" ondblclick="disp('_dSmo')" style="width:100x;height:25px">  </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dDocumentsType');Amm();Cmm();Dmm()" ondblclick="disp('_dDocumentsType')" style="width:100x;height:25px">   </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dSocial');Amm();Cmm();Dmm()" ondblclick="disp('_dSocial')" style="width:100x;height:25px">  </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dRegions');Amm();Cmm();Dmm()" ondblclick="disp('_dRegions')" style="width:100x;height:25px"> </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dSpecialization');Amm();Cmm();Dmm()" ondblclick="disp('_dSpecialization')" style="width:100x;height:25px"> </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dTreatmentResult');Amm();Cmm();Dmm()" ondblclick="disp('_dTreatmentResult')" style="width:100x;height:25px">  </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dReasonsVisitPolyclinics');Amm();Cmm();Dmm()" ondblclick="disp('_dReasonsVisitPolyclinics')" style="width:100x;height:25px">    </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dDiagnosisTypes');Amm();Cmm();Dmm()" ondblclick="disp('_dDiagnosisTypes')" style="width:100x;height:25px"> </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dInjuryTypes');Amm();Cmm();Dmm()" ondblclick="disp('_dInjuryTypes')" style="width:100x;height:25px"> </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dProfileOMSHospitals');Amm();Cmm();Dmm()" ondblclick="disp('_dProfileOMSHospitals')" style="width:100x;height:25px">   </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dPolyclinicOperations');Amm();Cmm();Dmm()" ondblclick="disp('_dPolyclinicOperations')" style="width:100x;height:25px">  </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dHospitalsOperations');Amm();Cmm();Dmm()" ondblclick="disp('_dHospitalsOperations')" style="width:100x;height:25px">    </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dProfilesKSG');Amm();Cmm();Dmm()" ondblclick="disp('_dProfilesKSG')" style="width:100x;height:25px"> </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dProfileOMSPolyclinics');Amm();Cmm();Dmm()" ondblclick="disp('_dProfileOMSPolyclinics')" style="width:100x;height:25px">   </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dImmutable');Cmm();Amm();Dmm()" ondblclick="disp('_dImmutable')" style="width:100x;height:25px"> </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="disp('CSG');Cmm();Bmm()" style="width:100x;height:25px"></button>
							<div id="CSG" class="divStyle" hidden="true" align="left">
								<table border="0" bgcolor="#F5F5DC" align="left">
									<tr>
										<td>
											<b>---></b>
											<button onclick="Bmm('_dCSGHosp');Cmm();Dmm();Amm()" ondblclick="disp('_dCSGHosp')" style="width:100x;height:25px"></button>
										</td>
									</tr>
									<tr>
										<td>
											<b>---></b>
											<button onclick="Bmm('_dCSGHospDay');Cmm();Dmm();Amm()" ondblclick="disp('_dCSGHospDay')" style="width:100x;height:25px">  </button>
										</td>
									</tr>
									<tr>
										<td>
											<b>---></b>
											<button onclick="Bmm('_dCSGHospHome');Cmm();Dmm();Amm()" ondblclick="disp('_dCSGHospHome')" style="width:100x;height:25px">   </button>
										</td>
									</tr>
									<tr>
										<td>
											<b>---></b>
											<button onclick="Bmm('_dCSGPoly');Cmm();Dmm();Amm()" ondblclick="disp('^dCSGHospPoly')" style="width:100x;height:25px"></button>
										</td>
									</tr>
								</table>
							</div>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dDrugs');Cmm();Amm();Dmm()" ondblclick="disp('_dDrugs')" style="width:100x;height:25px"> </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dExmaterial');Cmm();Amm();Dmm()" ondblclick="disp('_dExmaterial')" style="width:100x;height:25px"> </button>
						</td>
					</tr>
					<tr>
						<td>
							<button onclick="Bmm('_dSmp');Cmm();Amm();Dmm()" ondblclick="disp('_dSmp')" style="width:100x;height:25px">  </button>
						</td>
					</tr>
				</table>
			</td>
			<td width="80%" height="250px" valign="top">
				<table width="100%" cellpadding="0" col="2">
					<td width="30%" valign="top">
						<xsl:for-each select="body/SimpleMedicalServices/Type_sms">
							<xsl:variable name="Co" select="@code"/>
							<div id="_{$Co}" class="divStyle" hidden="true">
								<table width="100%" cellpadding="0">
									<thead bgcolor="#48D1CC">
										<tr bgcolor="#48D1CC">
											<td colspan="3">
												<b>
													<xsl:value-of select="@name"/>
												</b>
											</td>
										</tr>
										<tr bgcolor="#48D1CC">
											<td></td>
											<td></td>
										</tr>
									</thead>
									<xsl:for-each select="Group">
										<xsl:variable name="Gc" select="@name"/>
										<tr>
											<xsl:if test="position() mod 2 = 0">
												<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
											</xsl:if>
											<td>
												<xsl:value-of select="@code"/>
											</td>
											<td>
												<button onclick="Amm('^{$Gc}') " ondblclick="disp('^{$Gc}')">
													<xsl:value-of select="@name"/>
												</button>
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</div>
						</xsl:for-each>
						<div id="_dStandart" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b>
												</b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td></td>
										<td></td>
									</tr>
								</thead>
								<xsl:for-each select="body/StandartGroups/StandartGroup">
									<xsl:variable name="Ns" select="@name"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<button onclick="Amm('^{$Ns}')" ondblclick="disp('^{$Ns}')">
												<xsl:value-of select="@name"/>
											</button>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="_dComplex" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b> </b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td>  </td>
										<td>  </td>
									</tr>
								</thead>
								<xsl:for-each select="body/ComplexServicesGroup/ComplexServices">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<button onclick="Amm('^{$Cc}')" ondblclick="disp('^{$Cc}')">
												<xsl:call-template name="foot">
													<xsl:with-param name="C1" select="$Cc"/>
												</xsl:call-template>
											</button>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="_dImmutable" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b> </b>
										</td>
									</tr>
								</thead>								
								<tr>
									<td>
										<button onclick="Amm('^dMedicalStates') " ondblclick="disp('^dMedicalStates')" style="width:100x;height:25px">  </button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^dChamberTypes')" ondblclick="disp('^dChamberTypes')" style="width:100x;height:25px"> </button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^dMonths')" ondblclick="disp('^dMonths')" style="width:100x;height:25px"></button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^dCountries')" ondblclick="disp('^dCountries')" style="width:100x;height:25px"> </button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^dDegreeInvolvementSpecialists')" ondblclick="disp('^dDegreeInvolvementSpecialists')" style="width:100x;height:25px">  </button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^dVisitsTypes')" ondblclick="disp('^dVisitsTypes')" style="width:100x;height:25px"> </button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^dAgeGroups')" ondblclick="disp('^dAgeGroups')" style="width:100x;height:25px"> </button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^dDirectionsTypes')" ondblclick="disp('^dDirectionsTypes')" style="width:100x;height:25px"> </button>
									</td>
								</tr>
							</table>
						</div>
						<div id="_dCSGHosp" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b> </b>
										</td>
									</tr>
								</thead>
								<xsl:for-each select="body/CSG/CSG_Hospital/AgeGroups/AgeGroup">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center" width="40" valign="top">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<button onclick="Amm('^{$Cc}');Cmm();Dmm()" ondblclick="disp('^{$Cc}')">
												<xsl:value-of select="@name"/>
											</button>
											<div id="^{$Cc}" class="divStyle" hidden="true">
												<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
													<tr bgcolor="#48D1CC">
														<td>  </td>
														<td>  </td>
													</tr>
													<xsl:for-each select="CSGProfiles/CSGProfile">
														<xsl:variable name="NNa" select="@name"/>
														<tr>
															<xsl:if test="position() mod 2 = 0">
																<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
															</xsl:if>
															<xsl:if test="position() mod 2 = 1">
																<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
															</xsl:if>
															<td align="center" width="30">
																<xsl:value-of select="@code"/>
															</td>
															<td>
																<button onclick="Cmm('*{$Cc}{$NNa}');Dmm()" ondblclick="disp('*{$Cc}{$NNa}')">
																	<xsl:value-of select="@name"/>
																</button>
															</td>
														</tr>
													</xsl:for-each>
												</table>
											</div>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="_dCSGHospDay" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b>  </b>
										</td>
									</tr>
								</thead>
								<xsl:for-each select="body/CSG/CSG_Hospital_Day/AgeGroups/AgeGroup">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center" width="40" valign="top">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<button onclick="Amm('^{$Cc}day');Cmm();Dmm()" ondblclick="disp('^{$Cc}day')">
												<xsl:value-of select="@name"/>
											</button>
											<div id="^{$Cc}day" class="divStyle" hidden="true">
												<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
													<tr bgcolor="#48D1CC">
														<td>  </td>
														<td>  </td>
													</tr>
													<xsl:for-each select="CSGProfiles/CSGProfile">
														<xsl:variable name="NNa" select="@name"/>
														<tr>
															<xsl:if test="position() mod 2 = 0">
																<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
															</xsl:if>
															<xsl:if test="position() mod 2 = 1">
																<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
															</xsl:if>
															<td align="center" width="30">
																<xsl:value-of select="@code"/>
															</td>
															<td>
																<button onclick="Cmm('*{$Cc}{$NNa}day');Dmm()" ondblclick="disp('*{$Cc}{$NNa}day')">
																	<xsl:value-of select="@name"/>
																</button>
															</td>
														</tr>
													</xsl:for-each>
												</table>
											</div>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="_dCSGHospHome" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b>   </b>
										</td>
									</tr>
								</thead>
								<xsl:for-each select="body/CSG/CSG_Hospital_Home/AgeGroups/AgeGroup">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center" width="40" valign="top">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<button onclick="Amm('^{$Cc}home');Cmm();Dmm()" ondblclick="disp('^{$Cc}home')">
												<xsl:value-of select="@name"/>
											</button>
											<div id="^{$Cc}home" class="divStyle" hidden="true">
												<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
													<tr bgcolor="#48D1CC">
														<td>  </td>
														<td>  </td>
													</tr>
													<xsl:for-each select="CSGProfiles/CSGProfile">
														<xsl:variable name="NNa" select="@name"/>
														<tr>
															<xsl:if test="position() mod 2 = 0">
																<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
															</xsl:if>
															<xsl:if test="position() mod 2 = 1">
																<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
															</xsl:if>
															<td align="center" width="30">
																<xsl:value-of select="@code"/>
															</td>
															<td>
																<button onclick="Cmm('*{$Cc}{$NNa}home');Dmm()" ondblclick="disp('*{$Cc}{$NNa}home')">
																	<xsl:value-of select="@name"/>
																</button>
															</td>
														</tr>
													</xsl:for-each>
												</table>
											</div>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="_dCSGPoly" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b> </b>
										</td>
									</tr>
								</thead>
								<xsl:for-each select="body/CSG/CSG_Polyclinic/AgeGroups/AgeGroup">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center" width="40" valign="top">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<button onclick="Amm('^{$Cc}Poly');Cmm();Dmm()" ondblclick="disp('^{$Cc}Poly')">
												<xsl:value-of select="@name"/>
											</button>
											<div id="^{$Cc}Poly" class="divStyle" hidden="true">
												<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
													<tr bgcolor="#48D1CC">
														<td>  </td>
														<td>  </td>
													</tr>
													<xsl:for-each select="CSGProfiles/CSGProfile">
														<xsl:variable name="NNa" select="@name"/>
														<tr>
															<xsl:if test="position() mod 2 = 0">
																<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
															</xsl:if>
															<xsl:if test="position() mod 2 = 1">
																<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
															</xsl:if>
															<td align="center" width="30">
																<xsl:value-of select="@code"/>
															</td>
															<td>
																<button onclick="Cmm('*{$Cc}{$NNa}Poly');Dmm()" ondblclick="disp('*{$Cc}{$NNa}Poly')">
																	<xsl:value-of select="@name"/>
																</button>
															</td>
														</tr>
													</xsl:for-each>
												</table>
											</div>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="_dDrugs" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" col="2" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b>
													 
												</b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td></td>
										<td></td>
									</tr>
								</thead>
								<xsl:for-each select="body/MNNs/MNN">
									<xsl:variable name="MnnC" select="@code"/>
									<xsl:variable name="MnnN" select="@name"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td>
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<button onclick="Amm('^{$MnnC}{$MnnN}') " ondblclick="disp('^{$MnnC}{$MnnN}')">
												<xsl:value-of select="@name"/>
											</button>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="_dExmaterial" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" col="2" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b>
													 
												</b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td></td>
										<td></td>
									</tr>
								</thead>
								<xsl:for-each select="body/ExpendableMaterialsGroups/ExpendableMaterialsGroup">
									<xsl:variable name="ExC" select="@code"/>
									<xsl:variable name="ExN" select="@name"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td>
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<button onclick="Amm('^{$ExC}{$ExN}') " ondblclick="disp('^{$ExC}{$ExN}')">
												<xsl:value-of select="@name"/>
											</button>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
					</td>
					<td width="70%" valign="top">
						<table>
							<td width="100%">
								<xsl:for-each select="body/SimpleMedicalServices/Type_sms/Group">
									<xsl:variable name="Gc" select="@name"/>
									<div id="^{$Gc}" class="divStyle" hidden="true">
										<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
											<thead bgcolor="#48D1CC">
												<tr bgcolor="#48D1CC">
													<td colspan="14">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
												<tr bgcolor="#48D1CC">
													<td>  </td>
													<td>   </td>
													<td>  </td>
													<td></td>
													<td>  </td>
													<td>  </td>
													<td>,    1    </td>
													<td> </td>													
													<td> </td>													
													<td> </td>
													<td> </td>
													<td> </td>													
													<td> </td>
													<td>  </td>
												</tr>
											</thead>
											<xsl:for-each select="sms">
												<tr>
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center">
														<xsl:value-of select="@code"/>
													</td>
													<td align="center">
														<xsl:value-of select="@federal_code"/>
													</td>
													<td>
														<xsl:value-of select="@name"/>
													</td>
													<td align="center">
														<xsl:value-of select="@service_sign"/>
													</td>
													<td align="center">
														<xsl:value-of select="@t_sign"/>
													</td>
													<td align="center">
														<xsl:value-of select="@t_sign_2"/>
													</td>
													<td align="center">
														<xsl:value-of select="@one_visit_sign"/>
													</td>
													<td align="center">
														<xsl:value-of select="@min_year"/>
													</td>
													<td align="center">
														<xsl:value-of select="@min_month"/>
													</td>
													<td align="center">
														<xsl:value-of select="@min_day"/>
													</td>
													<td align="center">
														<xsl:value-of select="@max_year"/>
													</td>
													<td align="center">
														<xsl:value-of select="@max_month"/>
													</td>
													<td align="center">
														<xsl:value-of select="@max_day"/>
													</td>
													<td align="center">
														<xsl:value-of select="@place_sign"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
								</xsl:for-each>
								<xsl:for-each select="body/StandartGroups/StandartGroup">
									<xsl:variable name="Ns" select="@name"/>
									<div id="^{$Ns}" class="divStyle" hidden="true">
										<table width="100%" cellpadding="0">
											<thead bgcolor="#48D1CC">
												<tr bgcolor="#48D1CC">
													<th colspan="2">
														<xsl:value-of select="@name"/>
													</th>
												</tr>
												<tr bgcolor="#48D1CC">
													<th colspan="2">
														<button onclick="disp('{$Ns}')" ondblclick="disp('{$Ns}')">
															  ------------------------------------------------------
															</button>
													</th>
												</tr>
												<tr>
													<td colspan="2">
														<xsl:for-each select="Diagnoses">
															<tr>
																<td colspan="2">
																	<div id="{$Ns}" class="divStyle" hidden="true">
																		<table width="100%" bgcolor="#000000" cellspacing="1">
																			<thead bgcolor="#48D1CC">
																				<tr bgcolor="#48D1CC">
																					<td colspan="2" align="center"></td>
																				</tr>
																			</thead>
																			<xsl:for-each select="Diagnosis">
																				<tr>
																					<xsl:if test="position() mod 2 = 0">
																						<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
																					</xsl:if>
																					<xsl:if test="position() mod 2 = 1">
																						<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
																					</xsl:if>
																					<td colspan="2" align="center">
																						<xsl:value-of select="@mkb_code"/>
																					</td>
																				</tr>
																			</xsl:for-each>
																		</table>
																	</div>
																</td>
															</tr>
														</xsl:for-each>
													</td>
												</tr>
											</thead>
											<thead bgcolor="#48D1CC">
												<tr bgcolor="#48D1CC">
													<th colspan="2">
														<button onclick="disp('{$Ns}Mnn')" ondblclick="disp('{$Ns}Mnn')">
															  -------------- --------------
															</button>
													</th>
												</tr>
												<tr>
													<td colspan="2">
														<xsl:for-each select="MNNs">
															<tr>
																<td colspan="2">
																	<div id="{$Ns}Mnn" class="divStyle" hidden="true">
																		<table width="100%" bgcolor="#000000" cellspacing="1">
																			<thead bgcolor="#48D1CC">
																				<tr bgcolor="#48D1CC">
																					<td colspan="1" align="center"></td>
																					<td colspan="1" align="center"></td>
																				</tr>
																			</thead>
																			<xsl:for-each select="MNN">
																				<xsl:variable name="Mnn" select="@code"/>
																				<tr>
																					<xsl:if test="position() mod 2 = 0">
																						<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
																					</xsl:if>
																					<xsl:if test="position() mod 2 = 1">
																						<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
																					</xsl:if>
																					<td colspan="1" align="center">
																						<xsl:value-of select="@code"/>
																					</td>
																					<td align="left">
																						<xsl:call-template name="foot3">
																							<xsl:with-param name="C1" select="$Mnn"/>
																						</xsl:call-template>
																					</td>
																				</tr>
																			</xsl:for-each>
																		</table>
																	</div>
																</td>
															</tr>
														</xsl:for-each>
													</td>
												</tr>
											</thead>
											<thead bgcolor="#48D1CC">
												<tr bgcolor="#48D1CC">
													<th colspan="2">
														<button onclick="disp('{$Ns}expendable ')" ondblclick="disp('{$Ns}expendable ')">
															  ---------------- ----------------
															</button>
													</th>
												</tr>
												<tr>
													<td colspan="2">
														<tr>
															<td colspan="2">
																<div id="{$Ns}expendable " class="divStyle" hidden="true">
																	<table width="100%" bgcolor="#000000" cellspacing="1">
																		<thead bgcolor="#48D1CC">
																			<tr bgcolor="#48D1CC">
																				<td colspan="1" align="center"></td>
																				<td colspan="1" align="center"></td>
																			</tr>
																		</thead>
																		<xsl:for-each select="ExpendableMaterials/ExpendableMaterial">
																			<xsl:variable name="Ex" select="@code"/>
																			<tr>
																				<xsl:if test="position() mod 2 = 0">
																					<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
																				</xsl:if>
																				<xsl:if test="position() mod 2 = 1">
																					<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
																				</xsl:if>
																				<td colspan="1" align="center">
																					<xsl:value-of select="@code"/>
																				</td>
																				<td align="left">
																					<xsl:call-template name="foot4">
																						<xsl:with-param name="C1" select="$Ex"/>
																					</xsl:call-template>
																				</td>
																			</tr>
																		</xsl:for-each>
																	</table>
																</div>
															</td>
														</tr>
													</td>
												</tr>
											</thead>
											<thead bgcolor="#48D1CC">
												<tr bgcolor="#48D1CC">
													<td></td>
													<td></td>
												</tr>
											</thead>
											<xsl:for-each select="Standart">
												<xsl:variable name="St" select="@name"/>
												<tr>
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<td valign="top" align="center">
														<xsl:value-of select="@code"/>
													</td>
													<td>
														<button onclick="disp('*{$St}')">
															<xsl:value-of select="@name"/>
														</button>
														<div id="*{$St}" class="divStyle" hidden="true">
															<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
																<thead bgcolor="#48D1CC">
																	<tr bgcolor="#48D1CC">
																		<td></td>
																		<td></td>
																		<td> </td>
																	</tr>
																</thead>
																<xsl:for-each select="SimpleMedicalService/sms_s">
																	<xsl:variable name="SmsC" select="@code"/>
																	<tr>
																		<xsl:if test="position() mod 2 = 0">
																			<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
																		</xsl:if>
																		<xsl:if test="position() mod 2 = 1">
																			<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
																		</xsl:if>
																		<td align="left">
																			<xsl:value-of select="@code"/>
																		</td>
																		<td align="left">
																			<xsl:call-template name="foot">
																				<xsl:with-param name="C1" select="$SmsC"/>
																			</xsl:call-template>
																		</td>
																		<td align="left">
																			<xsl:call-template name="foot2">
																				<xsl:with-param name="C1" select="$SmsC"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</xsl:for-each>
															</table>
														</div>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
								</xsl:for-each>
								<xsl:for-each select="body/ComplexServicesGroup/ComplexServices">
									<xsl:variable name="Cc" select="@code"/>
									<div id="^{$Cc}" class="divStyle" hidden="true">
										<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
											<thead bgcolor="#48D1CC">
												<tr bgcolor="#48D1CC">
													<td colspan="3">
														<xsl:call-template name="foot">
															<xsl:with-param name="C1" select="$Cc"/>
														</xsl:call-template>
													</td>
												</tr>
												<tr bgcolor="#48D1CC">
													<td></td>
													<td></td>
													<td> </td>
												</tr>
											</thead>
											<xsl:for-each select="ComplexSer">
												<xsl:variable name="Csc" select="@code"/>
												<tr>
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td valign="top" align="left">
														<xsl:value-of select="@code"/>
													</td>
													<td align="left">
														<xsl:call-template name="foot">
															<xsl:with-param name="C1" select="$Csc"/>
														</xsl:call-template>
													</td>
													<td align="left">
														<xsl:call-template name="foot2">
															<xsl:with-param name="C1" select="$Csc"/>
														</xsl:call-template>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
								</xsl:for-each>
								<xsl:for-each select="body/CSG/CSG_Hospital/AgeGroups/AgeGroup">
									<xsl:variable name="Cc" select="@code"/>
									<xsl:for-each select="CSGProfiles/CSGProfile">
										<xsl:variable name="NNa" select="@name"/>
										<div id="*{$Cc}{$NNa}" class="divStyle" hidden="true">
											<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
												<tr bgcolor="#48D1CC">
													<td>  </td>
													<td>  </td>
													<td>   </td>
													<td>   80%</td>
													<td>   120%</td>
												</tr>
												<xsl:for-each select="CSGs/CSG">
													<xsl:variable name="Ca" select="@code"/>
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30" valign="top">
															<xsl:value-of select="@code"/>
														</td>
														<td>
															<button onclick="Dmm('@{$Ca}')" ondblclick="disp('@{$Ca}')">
																<xsl:value-of select="@name"/>
															</button>
															<div id="@{$Ca}" class="divStyle" hidden="true">
																<table width="100%" bgcolor="#000000" cellspacing="1">
																	<thead bgcolor="#48D1CC">
																		<tr bgcolor="#48D1CC">
																			<td></td>
																		</tr>
																	</thead>
																	<xsl:for-each select="MKBs/MKB">
																		<tr>
																			<xsl:if test="position() mod 2 = 0">
																				<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
																			</xsl:if>
																			<xsl:if test="position() mod 2 = 1">
																				<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
																			</xsl:if>
																			<td valign="top" align="left">
																				<xsl:value-of select="@code"/>
																			</td>
																		</tr>
																	</xsl:for-each>
																</table>
															</div>
														</td>
														<td align="center" valign="top">
															<xsl:value-of select="@duration"/>
														</td>
														<td align="center" valign="top">
															<xsl:value-of select="@duration_80persent"/>
														</td>
														<td align="center" valign="top">
															<xsl:value-of select="@duration_120persent"/>
														</td>
													</tr>
												</xsl:for-each>
											</table>
										</div>
									</xsl:for-each>
								</xsl:for-each>
								<xsl:for-each select="body/CSG/CSG_Hospital_Day/AgeGroups/AgeGroup">
									<xsl:variable name="Cc" select="@code"/>
									<xsl:for-each select="CSGProfiles/CSGProfile">
										<xsl:variable name="NNa" select="@name"/>
										<div id="*{$Cc}{$NNa}day" class="divStyle" hidden="true">
											<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
												<tr bgcolor="#48D1CC">
													<td>  </td>
													<td>  </td>
													<td>   </td>
													<td>   90%</td>
													<td>   110%</td>
												</tr>
												<xsl:for-each select="CSGs/CSG">
													<xsl:variable name="Ca" select="@code"/>
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30" valign="top">
															<xsl:value-of select="@code"/>
														</td>
														<td>
															<button onclick="Dmm('@{$Ca}day')" ondblclick="disp('@{$Ca}day')">
																<xsl:value-of select="@name"/>
															</button>
															<div id="@{$Ca}day" class="divStyle" hidden="true">
																<table width="100%" bgcolor="#000000" cellspacing="1">
																	<thead bgcolor="#48D1CC">
																		<tr bgcolor="#48D1CC">
																			<td></td>
																		</tr>
																	</thead>
																	<xsl:for-each select="MKBs/MKB">
																		<tr>
																			<xsl:if test="position() mod 2 = 0">
																				<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
																			</xsl:if>
																			<xsl:if test="position() mod 2 = 1">
																				<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
																			</xsl:if>
																			<td valign="top" align="left">
																				<xsl:value-of select="@code"/>
																			</td>
																		</tr>
																	</xsl:for-each>
																</table>
															</div>
														</td>
														<td align="center" valign="top">
															<xsl:value-of select="@duration"/>
														</td>
														<td align="center" valign="top">
															<xsl:value-of select="@duration_90persent"/>
														</td>
														<td align="center" valign="top">
															<xsl:value-of select="@duration_110persent"/>
														</td>
													</tr>
												</xsl:for-each>
											</table>
										</div>
									</xsl:for-each>
								</xsl:for-each>
								<xsl:for-each select="body/CSG/CSG_Hospital_Home/AgeGroups/AgeGroup">
									<xsl:variable name="Cc" select="@code"/>
									<xsl:for-each select="CSGProfiles/CSGProfile">
										<xsl:variable name="NNa" select="@name"/>
										<div id="*{$Cc}{$NNa}home" class="divStyle" hidden="true">
											<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
												<tr bgcolor="#48D1CC">
													<td>  </td>
													<td>  </td>
													<td>   </td>
													<td>   90%</td>
													<td>   110%</td>
												</tr>
												<xsl:for-each select="CSGs/CSG">
													<xsl:variable name="Ca" select="@code"/>
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30" valign="top">
															<xsl:value-of select="@code"/>
														</td>
														<td>
															<button onclick="Dmm('@{$Ca}home')" ondblclick="disp('@{$Ca}home')">
																<xsl:value-of select="@name"/>
															</button>
															<div id="@{$Ca}home" class="divStyle" hidden="true">
																<table width="100%" bgcolor="#000000" cellspacing="1">
																	<thead bgcolor="#48D1CC">
																		<tr bgcolor="#48D1CC">
																			<td></td>
																		</tr>
																	</thead>
																	<xsl:for-each select="MKBs/MKB">
																		<tr>
																			<xsl:if test="position() mod 2 = 0">
																				<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
																			</xsl:if>
																			<xsl:if test="position() mod 2 = 1">
																				<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
																			</xsl:if>
																			<td valign="top" align="left">
																				<xsl:value-of select="@code"/>
																			</td>
																		</tr>
																	</xsl:for-each>
																</table>
															</div>
														</td>
														<td align="center" valign="top">
															<xsl:value-of select="@duration"/>
														</td>
														<td align="center" valign="top">
															<xsl:value-of select="@duration_90persent"/>
														</td>
														<td align="center" valign="top">
															<xsl:value-of select="@duration_110persent"/>
														</td>
													</tr>
												</xsl:for-each>
											</table>
										</div>
									</xsl:for-each>
								</xsl:for-each>
								<xsl:for-each select="body/CSG/CSG_Polyclinic/AgeGroups/AgeGroup">
									<xsl:variable name="Cc" select="@code"/>
									<xsl:for-each select="CSGProfiles/CSGProfile">
										<xsl:variable name="NNa" select="@name"/>
										<div id="*{$Cc}{$NNa}Poly" class="divStyle" hidden="true">
											<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
												<tr bgcolor="#48D1CC">
													<td>  </td>
													<td>  </td>
												</tr>
												<xsl:for-each select="CSGs/CSG">
													<xsl:variable name="Ca" select="@code"/>
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30" valign="top">
															<xsl:value-of select="@code"/>
														</td>
														<td>
															<button onclick="Dmm('@{$Ca}Poly')" ondblclick="disp('@{$Ca}Poly')">
																<xsl:value-of select="@name"/>
															</button>
															<div id="@{$Ca}Poly" class="divStyle" hidden="true">
																<table width="100%" cellspacing="1">
																	<thead bgcolor="#48D1CC">
																		<tr bgcolor="#48D1CC">
																			<td colspan="2"></td>
																		</tr>
																	</thead>
																	<tr>
																		<td>
																			<button onclick="disp('MKB1{$Ca}')"></button>
																			<div id="MKB1{$Ca}" class="divStyle" hidden="true">
																				<table>
																					<thead bgcolor="#48D1CC">
																						<tr bgcolor="#48D1CC">
																							<td> </td>
																						</tr>
																					</thead>
																					<xsl:for-each select="MKBs/MKB">
																						<tr>
																							<xsl:if test="position() mod 2 = 0">
																								<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
																							</xsl:if>
																							<xsl:if test="position() mod 2 = 1">
																								<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
																							</xsl:if>
																							<td valign="top" align="left">
																								<xsl:value-of select="@code"/>
																							</td>
																						</tr>
																					</xsl:for-each>
																				</table>
																			</div>
																		</td>
																	</tr>
																	<thead bgcolor="#48D1CC">
																		<tr bgcolor="#48D1CC">
																			<td colspan="2"></td>
																		</tr>
																	</thead>
																	<tr>
																		<td>
																			<button onclick="disp('SPEC1{$Ca}')"></button>
																			<div id="SPEC1{$Ca}" class="divStyle" hidden="true">
																				<table>
																					<thead bgcolor="#48D1CC">
																						<tr bgcolor="#48D1CC">
																							<td></td>
																							<td></td>
																						</tr>
																					</thead>
																					<xsl:for-each select="Specialists/Specialict">
																						<tr>
																							<xsl:if test="position() mod 2 = 0">
																								<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
																							</xsl:if>
																							<xsl:if test="position() mod 2 = 1">
																								<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
																							</xsl:if>
																							<td valign="top" align="left">
																								<xsl:value-of select="@code"/>
																							</td>
																							<td valign="top" align="left">
																								<xsl:value-of select="@name"/>
																							</td>
																						</tr>
																					</xsl:for-each>
																				</table>
																			</div>
																		</td>
																	</tr>
																	<thead bgcolor="#48D1CC">
																		<tr bgcolor="#48D1CC">
																			<td colspan="2">  </td>
																		</tr>
																	</thead>
																	<tr>
																		<td>
																			<button onclick="disp('SMS1{$Ca}')">  </button>
																			<div id="SMS1{$Ca}" class="divStyle" hidden="true">
																				<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
																					<thead bgcolor="#48D1CC">
																						<tr bgcolor="#48D1CC">
																							<td></td>
																							<td></td>
																							<td></td>
																							<td></td>
																							<td></td>
																						</tr>
																					</thead>
																					<xsl:for-each select="SimpleMedicalServices/sms">
																						<tr>
																							<xsl:if test="position() mod 2 = 0">
																								<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
																							</xsl:if>
																							<xsl:if test="position() mod 2 = 1">
																								<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
																							</xsl:if>
																							<td valign="top" align="left">
																								<xsl:value-of select="@code"/>
																							</td>
																							<td>
																								<xsl:call-template name="foot">
																									<xsl:with-param name="C1" select="@code"/>
																								</xsl:call-template>
																							</td>
																							<td valign="top" align="left">
																								<xsl:value-of select="@appointment_level"/>
																							</td>
																							<td valign="top" align="left">
																								<xsl:value-of select="@fequency"/>
																							</td>
																							<td valign="top" align="left">
																								<xsl:value-of select="@nominal_quantity"/>
																							</td>
																						</tr>
																					</xsl:for-each>
																				</table>
																			</div>
																		</td>
																	</tr>
																</table>
															</div>
														</td>
													</tr>
												</xsl:for-each>
											</table>
										</div>
									</xsl:for-each>
								</xsl:for-each>
								<xsl:for-each select="body/MNNs/MNN">
									<xsl:variable name="MnnC" select="@code"/>
									<xsl:variable name="MnnN" select="@name"/>
									<div id="^{$MnnC}{$MnnN}" class="divStyle" hidden="true">
										<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
											<thead bgcolor="#48D1CC">
												<tr bgcolor="#48D1CC">
													<td colspan="2">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
												<tr bgcolor="#48D1CC">
													<td>  </td>
													<td>  </td>
												</tr>
											</thead>
											<xsl:for-each select="Trns/Trn">
												<tr>
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center">
														<xsl:value-of select="@code"/>
													</td>
													<td>
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
								</xsl:for-each>
								<xsl:for-each select="body/ExpendableMaterialsGroups/ExpendableMaterialsGroup">
									<xsl:variable name="ExC" select="@code"/>
									<xsl:variable name="ExN" select="@name"/>
									<div id="^{$ExC}{$ExN}" class="divStyle" hidden="true">
										<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
											<thead bgcolor="#48D1CC">
												<tr bgcolor="#48D1CC">
													<td colspan="2">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
												<tr bgcolor="#48D1CC">
													<td>  </td>
													<td>  </td>
												</tr>
											</thead>
											<xsl:for-each select="ExpendableMaterials/ExpendableMaterial">
												<tr>
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center">
														<xsl:value-of select="@code"/>
													</td>
													<td>
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
								</xsl:for-each>
								<xsl:for-each select="bode/SMP">
								
								</xsl:for-each>
							</td>
						</table>						
						<div id="^dMedicalStates" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b></b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td>  </td>
										<td>  </td>
									</tr>
								</thead>
								<xsl:for-each select="body/MedicalStates/MedicalState">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center" width="30">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<xsl:value-of select="@name"/>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="^dChamberTypes" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b></b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td>  </td>
										<td>  </td>
									</tr>
								</thead>
								<xsl:for-each select="body/ChamberTypes/ChamberType">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center" width="30">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<xsl:value-of select="@name"/>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="^dMonths" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b></b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td>  </td>
										<td>  </td>
									</tr>
								</thead>
								<xsl:for-each select="body/Months/Month">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center" width="30">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<xsl:value-of select="@name"/>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="^dCountries" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b></b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td>  </td>
										<td>  </td>
									</tr>
								</thead>
								<xsl:for-each select="body/Countries/Countrie">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<xsl:value-of select="@name"/>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="^dDegreeInvolvementSpecialists" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b></b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td>  </td>
										<td>  </td>
									</tr>
								</thead>
								<xsl:for-each select="body/DegreeInvolvementSpecialists/DegreeInvolvementSpecialist">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center" width="30">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<xsl:value-of select="@name"/>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="^dVisitsTypes" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b></b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td>  </td>
										<td>  </td>
									</tr>
								</thead>
								<xsl:for-each select="body/VisitsTypes/VisitsType">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center" width="30">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<xsl:value-of select="@name"/>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="^dAgeGroups" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b></b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td>  </td>
										<td>  </td>
									</tr>
								</thead>
								<xsl:for-each select="body/AgeGroups/AgeGroup">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center" width="30">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<xsl:value-of select="@name"/>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
						<div id="^dDirectionsTypes" class="divStyle" hidden="true">
							<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
								<thead bgcolor="#48D1CC">
									<tr bgcolor="#48D1CC">
										<td colspan="3">
											<b></b>
										</td>
									</tr>
									<tr bgcolor="#48D1CC">
										<td>  </td>
										<td>  </td>
									</tr>
								</thead>
								<xsl:for-each select="body/DirectionsTypes/DirectionsType">
									<xsl:variable name="Cc" select="@code"/>
									<tr>
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
										</xsl:if>
										<xsl:if test="position() mod 2 = 1">
											<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
										</xsl:if>
										<td align="center" width="30">
											<xsl:value-of select="@code"/>
										</td>
										<td>
											<xsl:value-of select="@name"/>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</div>
					</td>
				</table>
				<div id="_dSmp" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" cellspacing="1">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="3">
									<b>
												  </b>
								</td>
							</tr>
						</thead>
						<td width="15%" valign="top">
							<table>
								<tr>
									<td>
										<button onclick="Amm('^SMP1')" ondblclick="disp('^1')">
												 
											</button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^SMP2')" ondblclick="disp('^2')">
												 
											</button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^SMP3')" ondblclick="disp('^3')">
												   
											</button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^SMP4')" ondblclick="disp('^4')">
												 
											</button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^SMP5')" ondblclick="disp('^5')">
												  
											</button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^SMP6')" ondblclick="disp('^6')">
												    
											</button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^SMP7')" ondblclick="disp('^7')">
												  
											</button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^SMP8')" ondblclick="disp('^8')">
												  
											</button>
									</td>
								</tr>
							</table>
						</td>
						<td width="75%" valign="top">
							<table width="100%" border="0">
								<td valign="top" width="100%">
									<div id="^SMP1" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/SMP/SmpCallReasons/SmpCallReason">
												<tr valign="top">
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center" width="30">
														<xsl:value-of select="@code"/>
													</td>
													<td width="500">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
									<div id="^SMP2" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/SMP/SmpCallTypes/SmpCallType">
												<tr valign="top">
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center" width="30">
														<xsl:value-of select="@code"/>
													</td>
													<td width="500">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
									<div id="^SMP3" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/SMP/SmpLateCheckOuts/SmpLateCheckOut">
												<tr valign="top">
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center" width="30">
														<xsl:value-of select="@code"/>
													</td>
													<td width="500">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
									<div id="^SMP4" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/SMP/SmpComeOutTypes/SmpComeOutType">
												<tr valign="top">
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center" width="30">
														<xsl:value-of select="@code"/>
													</td>
													<td width="500">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
									<div id="^SMP5" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/SMP/SmpAccidentCauses/SmpAccidentCause">
												<tr valign="top">
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center" width="30">
														<xsl:value-of select="@code"/>
													</td>
													<td width="500">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
									<div id="^SMP6" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/SMP/SmpPatientsStateTypes/SmpPatientsStateType">
												<tr valign="top">
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center" width="30">
														<xsl:value-of select="@code"/>
													</td>
													<td width="500">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
									<div id="^SMP7" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/SMP/SmpResults/SmpResult">
												<tr valign="top">
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center" width="30">
														<xsl:value-of select="@code"/>
													</td>
													<td width="500">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
									<div id="^SMP8" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/SMP/SmpComplications/SmpComplication">
												<tr valign="top">
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center" width="30">
														<xsl:value-of select="@code"/>
													</td>
													<td width="500">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
								</td>
							</table>
						</td>
					</table>
				</div>
				<div id="_dLpu" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" col="3">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="4">
									<b></b>
								</td>
							</tr>
						</thead>
						<td width="15%" valign="top">
							<table>
								<tr>
									<td>
										<button onclick="Amm('^LpuBody1');Cmm()" style="width:100x;height:25px" ondblclick="disp('^LpuBody1')"></button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^LpuBody2');Cmm()" style="width:100x;height:25px" ondblclick="disp('^LpuBody2')">  </button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^LpuBody3');Cmm()" style="width:100x;height:25px" ondblclick="disp('^LpuBody3')">.</button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^LpuBody4');Cmm()" style="width:100x;height:25px" ondblclick="disp('^LpuBody4')">.</button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^LpuBody5');Cmm()" style="width:100x;height:25px" ondblclick="disp('^LpuBody5')"></button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^LpuBody6');Cmm()" style="width:100x;height:25px" ondblclick="disp('^LpuBody6')"> </button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^LpuBody7');Cmm()" style="width:100x;height:25px" ondblclick="disp('^LpuBody7')">-</button>
									</td>
								</tr>
							</table>
						</td>
						<td width="50%" valign="top">
							<table width="100%" border="0">
								<td valign="top" width="100%">
									<div id="^LpuBody1" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td></td>
												<td>  </td>
												<td> </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/LPUs/LPU">
												<xsl:variable name="Ordr" select="@ordr"/>
												<xsl:variable name="LC" select="@code"/>
												<xsl:if test="$Ordr=1">
													<tr valign="top">
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<button onclick="Cmm('*LPUVidPom{$LC}')">
																<xsl:value-of select="@code"/>
															</button>
														</td>
														<td align="center" width="120">
															<xsl:value-of select="@ogrn"/>
														</td>
														<td width="500">
															<xsl:value-of select="@name"/>
														</td>
														<td>
															<xsl:choose>
																<xsl:when test="@single_financing_begin='0:00:00'"> </xsl:when>
																<xsl:otherwise> c
															<xsl:value-of select="@single_financing_begin"/> - 
															<xsl:value-of select="@single_financing_end"/>
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td align="center" width="60">
															<xsl:value-of select="@group"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^LpuBody2" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td></td>
												<td>  </td>
												<td> </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/LPUs/LPU">
												<xsl:variable name="Ordr" select="@ordr"/>
												<xsl:variable name="LC" select="@code"/>
												<xsl:if test="$Ordr=2">
													<tr valign="top">
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30" valign="top">
															<button onclick="Cmm('*LPUVidPom{$LC}')">
																<xsl:value-of select="@code"/>
															</button>
														</td>
														<td align="center" width="120" valign="top">
															<xsl:value-of select="@ogrn"/>
														</td>
														<td valign="top" width="500">
															<xsl:value-of select="@name"/>
														</td>
														<td>
															<xsl:choose>
																<xsl:when test="@single_financing_begin='0:00:00'"> </xsl:when>
																<xsl:otherwise> c
															<xsl:value-of select="@single_financing_begin"/> - 
															<xsl:value-of select="@single_financing_end"/>
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td align="center" width="60">
															<xsl:value-of select="@group"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^LpuBody3" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC">
												<td>  </td>
												<td></td>
												<td>  </td>
												<td> </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/LPUs/LPU">
												<xsl:variable name="Ordr" select="@ordr"/>
												<xsl:variable name="LC" select="@code"/>
												<xsl:if test="$Ordr=3">
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<button onclick="Cmm('*LPUVidPom{$LC}')">
																<xsl:value-of select="@code"/>
															</button>
														</td>
														<td align="center" width="120">
															<xsl:value-of select="@ogrn"/>
														</td>
														<td width="500">
															<xsl:value-of select="@name"/>
														</td>
														<td>
															<xsl:choose>
																<xsl:when test="@single_financing_begin='0:00:00'"> </xsl:when>
																<xsl:otherwise> c
															<xsl:value-of select="@single_financing_begin"/> - 
															<xsl:value-of select="@single_financing_end"/>
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td align="center" width="60">
															<xsl:value-of select="@group"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^LpuBody4" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC">
												<td>  </td>
												<td></td>
												<td>  </td>
												<td> </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/LPUs/LPU">
												<xsl:variable name="Ordr" select="@ordr"/>
												<xsl:variable name="LC" select="@code"/>
												<xsl:if test="$Ordr=4">
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<button onclick="Cmm('*LPUVidPom{$LC}')">
																<xsl:value-of select="@code"/>
															</button>
														</td>
														<td align="center" width="120">
															<xsl:value-of select="@ogrn"/>
														</td>
														<td width="500">
															<xsl:value-of select="@name"/>
														</td>
														<td>
															<xsl:choose>
																<xsl:when test="@single_financing_begin='0:00:00'"> </xsl:when>
																<xsl:otherwise> c
															<xsl:value-of select="@single_financing_begin"/> - 
															<xsl:value-of select="@single_financing_end"/>
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td align="center" width="60">
															<xsl:value-of select="@group"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^LpuBody5" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC">
												<td>  </td>
												<td></td>
												<td>  </td>
												<td> </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/LPUs/LPU">
												<xsl:variable name="Ordr" select="@ordr"/>
												<xsl:variable name="LC" select="@code"/>
												<xsl:if test="$Ordr=5">
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<button onclick="Cmm('*LPUVidPom{$LC}')">
																<xsl:value-of select="@code"/>
															</button>
														</td>
														<td align="center" width="120">
															<xsl:value-of select="@ogrn"/>
														</td>
														<td width="500">
															<xsl:value-of select="@name"/>
														</td>
														<td>
															<xsl:choose>
																<xsl:when test="@single_financing_begin='0:00:00'"> </xsl:when>
																<xsl:otherwise> c
															<xsl:value-of select="@single_financing_begin"/> - 
															<xsl:value-of select="@single_financing_end"/>
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td align="center" width="60">
															<xsl:value-of select="@group"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^LpuBody6" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC">
												<td>  </td>
												<td></td>
												<td>  </td>
												<td> </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/LPUs/LPU">
												<xsl:variable name="Ordr" select="@ordr"/>
												<xsl:variable name="LC" select="@code"/>
												<xsl:if test="$Ordr=6">
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<button onclick="Cmm('*LPUVidPom{$LC}')">
																<xsl:value-of select="@code"/>
															</button>
														</td>
														<td align="center" width="120">
															<xsl:value-of select="@ogrn"/>
														</td>
														<td width="500">
															<xsl:value-of select="@name"/>
														</td>
														<td>
															<xsl:choose>
																<xsl:when test="@single_financing_begin='0:00:00'"> </xsl:when>
																<xsl:otherwise> c
															<xsl:value-of select="@single_financing_begin"/> - 
															<xsl:value-of select="@single_financing_end"/>
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td align="center" width="60">
															<xsl:value-of select="@group"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^LpuBody7" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC">
												<td>  </td>
												<td></td>
												<td>  </td>
												<td> </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/LPUs/LPU">
												<xsl:variable name="Ordr" select="@ordr"/>
												<xsl:variable name="LC" select="@code"/>
												<xsl:if test="$Ordr=7">
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<button onclick="Cmm('*LPUVidPom{$LC}')">
																<xsl:value-of select="@code"/>
															</button>
														</td>
														<td align="center" width="120">
															<xsl:value-of select="@ogrn"/>
														</td>
														<td>
															<xsl:value-of select="@name"/>
														</td>
														<td>
															<xsl:choose>
																<xsl:when test="@single_financing_begin='0:00:00'"> </xsl:when>
																<xsl:otherwise> c
															<xsl:value-of select="@single_financing_begin"/> - 
															<xsl:value-of select="@single_financing_end"/>
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td align="center" width="60">
															<xsl:value-of select="@group"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
								</td>
							</table>
						</td>
						<td width="35%" valign="top">
							<xsl:for-each select="body/LPUs/LPU">
								<xsl:variable name="LC" select="@code"/>
								<div id="*LPUVidPom{$LC}" class="divStyle" hidden="true">
									<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
										<thead bgcolor="#48D1CC">
											<tr bgcolor="#48D1CC">
												<td></td>
												<td> </td>
												<td> </td>
												<td></td>
											</tr>
										</thead>
										<tr valign="top" bgcolor="#48D1CC">
											<td colspan="4"></td>
										</tr>
										<xsl:for-each select="Hospitals/Hospital">
											<tr>
												<xsl:if test="position() mod 2 = 0">
													<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
												</xsl:if>
												<xsl:if test="position() mod 2 = 1">
													<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
												</xsl:if>
												<td align="center">
													<xsl:value-of select="@code_prof"/>
												</td>
												<td align="left">
													<xsl:value-of select="@begin_date"/>
												</td>
												<td align="left">
													<xsl:value-of select="@end_date"/>
												</td>
												<td align="left">
													<xsl:value-of select="@foundation"/>
												</td>
											</tr>
										</xsl:for-each>
										<tr valign="top" bgcolor="#48D1CC">
											<td colspan="4"> </td>
										</tr>
										<xsl:for-each select="DayHospitals/DayHospital">
											<tr>
												<xsl:if test="position() mod 2 = 0">
													<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
												</xsl:if>
												<xsl:if test="position() mod 2 = 1">
													<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
												</xsl:if>
												<td align="center">
													<xsl:value-of select="@code_prof"/>
												</td>
												<td align="left">
													<xsl:value-of select="@begin_date"/>
												</td>
												<td align="left">
													<xsl:value-of select="@end_date"/>
												</td>
												<td align="left">
													<xsl:value-of select="@foundation"/>
												</td>
											</tr>
										</xsl:for-each>
										<tr valign="top" bgcolor="#48D1CC">
											<td colspan="4"></td>
										</tr>
										<xsl:for-each select="Polyclinics/Polyclinic">
											<tr>
												<xsl:if test="position() mod 2 = 0">
													<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
												</xsl:if>
												<xsl:if test="position() mod 2 = 1">
													<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
												</xsl:if>
												<td align="center">
													<xsl:value-of select="@code_prof"/>
												</td>
												<td align="left">
													<xsl:value-of select="@begin_date"/>
												</td>
												<td align="left">
													<xsl:value-of select="@end_date"/>
												</td>
												<td align="left">
													<xsl:value-of select="@foundation"/>
												</td>
											</tr>
										</xsl:for-each>
									</table>
								</div>
							</xsl:for-each>
						</td>
					</table>
				</div>
				<div id="_dSmo" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" col="2">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="4">
									<b></b>
								</td>
							</tr>
						</thead>
						<td width="20%" valign="top">
							<table>
								<tr>
									<td>
										<button onclick="Amm('^SmoBody1')" style="width:100x;height:25px" ondblclick="disp('^SmoBody1')"></button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^SmoBody2')" style="width:100x;height:25px" ondblclick="disp('^SmoBody2')"> </button>
									</td>
								</tr>
							</table>
						</td>
						<td width="80%" valign="top">
							<table width="100%" border="0">
								<td valign="top" width="100%">
									<div id="^SmoBody1" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td></td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/SMOs/YaroslavlRegionSMOs/YaroslavlRegionSMO">
												<tr valign="top">
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center" width="130">
														<xsl:value-of select="@ogrn"/>
													</td>
													<td>
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
									<div id="^SmoBody2" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td></td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/SMOs/OtherTerritoriesSMOs/OtherTerritoriesSMO">
												<tr valign="top">
													<xsl:if test="position() mod 2 = 0">
														<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
													</xsl:if>
													<xsl:if test="position() mod 2 = 1">
														<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
													</xsl:if>
													<td align="center" width="30" valign="top">
														<xsl:value-of select="@code_territories"/>
													</td>
													<td align="center" width="130" valign="top">
														<xsl:value-of select="@ogrn"/>
													</td>
													<td valign="top">
														<xsl:value-of select="@name"/>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</div>
								</td>
							</table>
						</td>
					</table>
				</div>
				<div id="_dDocumentsType" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="4">
									<b> </b>
								</td>
							</tr>
							<tr bgcolor="#48D1CC">
								<td>  </td>
								<td>  </td>
								<td> </td>
								<td> </td>
							</tr>
						</thead>
						<xsl:for-each select="body/DocumentTypes/DocumentType">
							<xsl:variable name="Cc" select="@code"/>
							<tr>
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
								</xsl:if>
								<td align="center" width="20">
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:value-of select="@name"/>
								</td>
								<td>
									<xsl:value-of select="@series_template"/>
								</td>
								<td>
									<xsl:value-of select="@number_template"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="_dSocial" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="3">
									<b> </b>
								</td>
							</tr>
							<tr bgcolor="#48D1CC">
								<td>  </td>
								<td>  </td>
							</tr>
						</thead>
						<xsl:for-each select="body/SocialCategories/SocialCategory">
							<xsl:variable name="Cc" select="@code"/>
							<tr>
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
								</xsl:if>
								<td align="center" width="20">
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:value-of select="@name"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="_dRegions" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" col="2">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="4">
									<b></b>
								</td>
							</tr>
						</thead>
						<td width="20%" valign="top">
							<table>
								<tr>
									<td>
										<button onclick="Amm('^Region1')" style="width:100x;height:25px" ondblclick="disp('^Region1')"></button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^Region2')" style="width:100x;height:25px" ondblclick="disp('^Region2')">-</button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^Region3')" style="width:100x;height:25px" ondblclick="disp('^Region3')"></button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^Region4')" style="width:100x;height:25px" ondblclick="disp('^Region4')"></button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^Region5')" style="width:100x;height:25px" ondblclick="disp('^Region5')"></button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^Region6')" style="width:100x;height:25px" ondblclick="disp('^Region6')"></button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^Region7')" style="width:100x;height:25px" ondblclick="disp('^Region7')"></button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^Region8')" style="width:100x;height:25px" ondblclick="disp('^Region8')">     </button>
									</td>
								</tr>
							</table>
						</td>
						<td width="80%" valign="top">
							<table width="100%" border="0">
								<td valign="top" width="100%">
									<div id="^Region1" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/Regions/Region">
												<xsl:variable name="Code_fed" select="@code_fed"/>
												<xsl:if test="$Code_fed=01">
													<tr valign="top">
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<xsl:value-of select="@code_region"/>
														</td>
														<td>
															<xsl:value-of select="@name"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^Region2" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/Regions/Region">
												<xsl:variable name="Code_fed" select="@code_fed"/>
												<xsl:if test="$Code_fed=03">
													<tr valign="top">
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<xsl:value-of select="@code_region"/>
														</td>
														<td>
															<xsl:value-of select="@name"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^Region3" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC">
												<td>  </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/Regions/Region">
												<xsl:variable name="Code_fed" select="@code_fed"/>
												<xsl:if test="$Code_fed=04">
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<xsl:value-of select="@code_region"/>
														</td>
														<td>
															<xsl:value-of select="@name"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^Region4" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC">
												<td>  </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/Regions/Region">
												<xsl:variable name="Code_fed" select="@code_fed"/>
												<xsl:if test="$Code_fed=05">
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<xsl:value-of select="@code_region"/>
														</td>
														<td>
															<xsl:value-of select="@name"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^Region5" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC">
												<td>  </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/Regions/Region">
												<xsl:variable name="Code_fed" select="@code_fed"/>
												<xsl:if test="$Code_fed=06">
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<xsl:value-of select="@code_region"/>
														</td>
														<td>
															<xsl:value-of select="@name"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^Region6" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC">
												<td>  </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/Regions/Region">
												<xsl:variable name="Code_fed" select="@code_fed"/>
												<xsl:if test="$Code_fed=07">
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<xsl:value-of select="@code_region"/>
														</td>
														<td>
															<xsl:value-of select="@name"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^Region7" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC">
												<td>  </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/Regions/Region">
												<xsl:variable name="Code_fed" select="@code_fed"/>
												<xsl:if test="$Code_fed=08">
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<xsl:value-of select="@code_region"/>
														</td>
														<td>
															<xsl:value-of select="@name"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^Region8" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC">
												<td>  </td>
												<td></td>
											</tr>
											<xsl:for-each select="body/Regions/Region">
												<xsl:variable name="Code_fed" select="@code_fed"/>
												<xsl:if test="$Code_fed=09">
													<tr>
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<xsl:value-of select="@code_region"/>
														</td>
														<td>
															<xsl:value-of select="@name"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
								</td>
							</table>
						</td>
					</table>
				</div>
				<div id="_dSpecialization" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="14">
									<b></b>
								</td>
							</tr>
							<tr bgcolor="#48D1CC">
								<td> </td>
								<td>  </td>
								<td> </td>
								<td> </td>
								<td> </td>
								<td>  </td>
								<td> </td>
								<td> </td>
								<td> </td>
								<td> </td>
								<td>-</td>
								<td></td>
								<td></td>
								<td></td>
							</tr>
						</thead>
						<xsl:for-each select="body/Specializations/Specialization">
							<xsl:variable name="Cc" select="@code"/>
							<tr>
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
								</xsl:if>
								<td align="center" width="20">
									<xsl:value-of select="@code"/>
								</td>
								<td width="270">
									<xsl:value-of select="@name"/>
								</td>
								<td align="center" width="30">
									<xsl:value-of select="@policlinic"/>
								</td>
								<td>
									<xsl:value-of select="@day_hospital"/>
								</td>
								<td>
									<xsl:value-of select="@hospital"/>
								</td>
								<td>
									<xsl:value-of select="@home_hospital"/>
								</td>
								<td>
									<xsl:value-of select="@policlinic_operation"/>
								</td>
								<td>
									<xsl:value-of select="@hospital_operation"/>
								</td>
								<td>
									<xsl:value-of select="@diagnostic"/>
								</td>
								<td>
									<xsl:value-of select="@laboratory"/>
								</td>
								<td>
									<xsl:value-of select="@physiotherapy"/>
								</td>
								<td>
									<xsl:value-of select="@reanimation"/>
								</td>
								<td>
									<xsl:value-of select="@intensive_care_block"/>
								</td>
								<td>
									<xsl:value-of select="@intensive_care_chamber"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="_dTreatmentResult" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" col="2">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="4">
									<b> </b>
								</td>
							</tr>
						</thead>
						<td width="20%" valign="top">
							<table>
								<tr>
									<td>
										<button onclick="Amm('^dTreatmentResult1')" style="width:100x;height:25px" ondblclick="disp('^dTreatmentResult1')"> </button>
									</td>
								</tr>
								<tr>
									<td>
										<button onclick="Amm('^dTreatmentResult2')" style="width:100x;height:25px" ondblclick="disp('^dTreatmentResult2')"> </button>
									</td>
								</tr>
							</table>
						</td>
						<td width="80%" valign="top">
							<table width="100%" border="0">
								<td valign="top" width="100%">
									<div id="^dTreatmentResult1" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/TreatmentResults/TreatmentResult">
												<xsl:variable name="Type" select="@type"/>
												<xsl:if test="$Type=1">
													<tr valign="top">
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30">
															<xsl:value-of select="@code"/>
														</td>
														<td>
															<xsl:value-of select="@name"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
									<div id="^dTreatmentResult2" class="divStyle" hidden="true">
										<table width="100%" border="0" bgcolor="#000000" cellspacing="1">
											<tr bgcolor="#48D1CC" valign="top">
												<td>  </td>
												<td>  </td>
											</tr>
											<xsl:for-each select="body/TreatmentResults/TreatmentResult">
												<xsl:variable name="Type" select="@type"/>
												<xsl:if test="$Type=0">
													<tr valign="top">
														<xsl:if test="position() mod 2 = 0">
															<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
														</xsl:if>
														<xsl:if test="position() mod 2 = 1">
															<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
														</xsl:if>
														<td align="center" width="30" valign="top">
															<xsl:value-of select="@code"/>
														</td>
														<td valign="top">
															<xsl:value-of select="@name"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</div>
								</td>
							</table>
						</td>
					</table>
				</div>
				<div id="_dReasonsVisitPolyclinics" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" bgcolor="#000000" cellspacing="1">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="4">
									<b>   </b>
								</td>
							</tr>
							<tr bgcolor="#48D1CC">
								<td>  </td>
								<td>  </td>
								<td>      </td>
							</tr>
						</thead>
						<xsl:for-each select="body/ReasonsVisitPolyclinics/ReasonsVisitPolyclinic">
							<xsl:variable name="Sign" select="@sign"/>
							<tr>
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
								</xsl:if>
								<td align="center" width="20">
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:value-of select="@name"/>
								</td>
								<td>
									<xsl:if test="$Sign=0">    </xsl:if>
									<xsl:if test="$Sign=1">   </xsl:if>
									<xsl:if test="$Sign=2">   </xsl:if>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="_dDiagnosisTypes" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" cellspacing="1" bgcolor="#000000">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="4">
									<b> </b>
								</td>
							</tr>
							<tr bgcolor="#48D1CC">
								<td>  </td>
								<td>  </td>
								<td>   </td>
							</tr>
						</thead>
						<xsl:for-each select="body/DiagnosisTypes/DiagnosisType">
							<xsl:variable name="Sign" select="@sign_types"/>
							<tr>
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
								</xsl:if>
								<td align="center" width="20">
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:value-of select="@name"/>
								</td>
								<td>
									<xsl:if test="$Sign=0">          </xsl:if>
									<xsl:if test="$Sign=1">       </xsl:if>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="_dInjuryTypes" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" cellspacing="1" bgcolor="#000000">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="4">
									<b> </b>
								</td>
							</tr>
							<tr bgcolor="#48D1CC">
								<td>  </td>
								<td>  </td>
								<td> </td>
							</tr>
						</thead>
						<xsl:for-each select="body/InjuryTypes/InjuryType">
							<xsl:variable name="Sign" select="@injury_sign"/>
							<tr>
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
								</xsl:if>
								<td align="center" width="20">
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:value-of select="@name"/>
								</td>
								<td>
									<xsl:if test="$Sign=0"></xsl:if>
									<xsl:if test="$Sign=1"> </xsl:if>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="_dProfileOMSHospitals" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="3">
									<b>   </b>
								</td>
							</tr>
							<tr bgcolor="#48D1CC">
								<td>  </td>
								<td>  </td>
							</tr>
						</thead>
						<xsl:for-each select="body/ProfileOMSHospitals/ProfileOMSHospital">
							<xsl:variable name="Cc" select="@code"/>
							<tr>
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
								</xsl:if>
								<td align="center" width="20">
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:value-of select="@name"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="_dPolyclinicOperations" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="3">
									<b>  </b>
								</td>
							</tr>
							<tr bgcolor="#48D1CC">
								<td>  </td>
								<td>  </td>
							</tr>
						</thead>
						<xsl:for-each select="body/PolyclinicOperations/PolyclinicOperation">
							<xsl:variable name="Cc" select="@code"/>
							<tr>
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
								</xsl:if>
								<td align="center" width="100">
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:value-of select="@name"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="_dHospitalsOperations" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="3">
									<b>    </b>
								</td>
							</tr>
							<tr bgcolor="#48D1CC">
								<td>  </td>
								<td>  </td>
								<td></td>
							</tr>
						</thead>
						<xsl:for-each select="body/HospitalsOperations/HospitalsOperation">
							<xsl:variable name="Cc" select="@code"/>
							<tr>
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
								</xsl:if>
								<td align="center" width="100">
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:value-of select="@name"/>
								</td>
								<td>
									<xsl:value-of select="@difficult"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="_dProfilesKSG" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="3">
									<b> </b>
								</td>
							</tr>
							<tr bgcolor="#48D1CC">
								<td>  </td>
								<td>  </td>
							</tr>
						</thead>
						<xsl:for-each select="body/ProfilesKSG/ProfileKSG">
							<xsl:variable name="Cc" select="@code"/>
							<tr>
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
								</xsl:if>
								<td align="center" width="20">
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:value-of select="@name"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="_dProfileOMSPolyclinics" class="divStyle" hidden="true">
					<table width="100%" cellpadding="0" border="0" bgcolor="#000000" cellspacing="1">
						<thead bgcolor="#48D1CC">
							<tr bgcolor="#48D1CC">
								<td colspan="6">
									<b>   </b>
								</td>
							</tr>
							<tr colspan="2" bgcolor="#48D1CC">
								<td/>
								<td/>
								<td colspan="2">
									<b>1 -     </b>
								</td>
								<td colspan="2">
									<b>2 -     </b>
								</td>
							</tr>
							<tr bgcolor="#48D1CC">
								<td>  </td>
								<td>  </td>
								<td>1 </td>
								<td>2 </td>
								<td>1 </td>
								<td>2 </td>
							</tr>
						</thead>
						<xsl:for-each select="body/ProfileOMSPolyclinics/ProfileOMSPolyclinic">
							<xsl:variable name="Cc" select="@code"/>
							<tr>
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">#FFFFF0</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">#F8F8FF</xsl:attribute>
								</xsl:if>
								<td align="center" width="20">
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:value-of select="@name"/>
								</td>
								<td>
									<xsl:value-of select="@ffoms1"/>
								</td>
								<td>
									<xsl:value-of select="@ffoms2"/>
								</td>
								<td>
									<xsl:value-of select="@tfoms1"/>
								</td>
								<td>
									<xsl:value-of select="@tfoms2"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
			</td>
		</table>
		<script type="text/javascript"><![CDATA[ 
                    function Bmm(A)
                    {
						var SHOF_key='block';
						var divstyle = new String();
						
						pre_elem=document.getElementsByTagName('div');
						
						if (SHOF_key != 'block') SHOF_key = 'block';
						else SHOF_key = 'none';
						pre_elem=document.getElementsByTagName('div');
						
						for(k=0;k<pre_elem.length;k++)
						{
							if(pre_elem[k].id.charAt(0) =='_')
							{
								document.getElementById(pre_elem[k].id).style.display = SHOF_key;
							}
						}
						
						divstyle = document.getElementById(A).style.display;
						if(divstyle.toLowerCase()=="block" || divstyle == "")
                        {
							 document.getElementById(A).style.display = "none";
                        }
						else
                        {
							 document.getElementById(A).style.display = "block";
                         }
                    }  
                    function Amm(A)
                    {
						var SHOF_key='block';
						pre_elem=document.getElementsByTagName('div');
						
						if (SHOF_key != 'block') SHOF_key = 'block';
						else SHOF_key = 'none';
						pre_elem=document.getElementsByTagName('div');
						
						for(k=0;k<pre_elem.length;k++)
						{
							if(pre_elem[k].id.charAt(0) =='^')
							{
								document.getElementById(pre_elem[k].id).style.display = SHOF_key;
							}
						}
						var divstyle = new String();
						divstyle = document.getElementById(A).style.display;
						if(divstyle.toLowerCase()=="block" || divstyle == "")
                        {
							 document.getElementById(A).style.display = "none";
                        }
						else
                        {
							 document.getElementById(A).style.display = "block";
                         }
                    }
                     function Cmm(A)
                    {
						var SHOF_key='block';
						pre_elem=document.getElementsByTagName('div');
						
						if (SHOF_key != 'block') SHOF_key = 'block';
						else SHOF_key = 'none';
						pre_elem=document.getElementsByTagName('div');
						
						for(k=0;k<pre_elem.length;k++)
						{
							if(pre_elem[k].id.charAt(0) =='*')
							{
								document.getElementById(pre_elem[k].id).style.display = SHOF_key;
							}
						}
						var divstyle = new String();
						divstyle = document.getElementById(A).style.display;
						if(divstyle.toLowerCase()=="block" || divstyle == "")
                        {
							 document.getElementById(A).style.display = "none";
                        }
						else
                        {
							 document.getElementById(A).style.display = "block";
                         }
                    }
                       function Dmm(A)
                    {
						var SHOF_key='block';
						pre_elem=document.getElementsByTagName('div');
						
						if (SHOF_key != 'block') SHOF_key = 'block';
						else SHOF_key = 'none';
						pre_elem=document.getElementsByTagName('div');
						
						for(k=0;k<pre_elem.length;k++)
						{
							if(pre_elem[k].id.charAt(0) =='@')
							{
								document.getElementById(pre_elem[k].id).style.display = SHOF_key;
							}
						}
						var divstyle = new String();
						divstyle = document.getElementById(A).style.display;
						if(divstyle.toLowerCase()=="block" || divstyle == "")
                        {
							 document.getElementById(A).style.display = "none";
                        }
						else
                        {
							 document.getElementById(A).style.display = "block";
                         }
                    }
                  
                    function disp(A)
                    {
                    var divstyle = new String();
                    divstyle = document.getElementById(A).style.display;
                    if(divstyle.toLowerCase()=="block" || divstyle == "")
                        {
                         document.getElementById(A).style.display = "none";
                        }
                    else
                        {
                         document.getElementById(A).style.display = "block";
                         }
                    }

]]></script>
	</xsl:template>
	<xsl:template name="foot">
		<xsl:param name="C1"/>
		<xsl:param name="C3">
			<xsl:for-each select="key('Search',$C1)">
				<xsl:variable name="C2" select="@code"/>
				<xsl:value-of select="@name"/>
			</xsl:for-each>
		</xsl:param>
		<xsl:value-of select="$C3"/>
	</xsl:template>
	<xsl:template name="foot2">
		<xsl:param name="C1"/>
		<xsl:param name="C3">
			<xsl:for-each select="key('Search',$C1)">
				<xsl:variable name="C2" select="@federal_code"/>
				<xsl:value-of select="@federal_code"/>
			</xsl:for-each>
		</xsl:param>
		<xsl:value-of select="$C3"/>
	</xsl:template>
	<xsl:template name="foot3">
		<xsl:param name="C1"/>
		<xsl:param name="C3">
			<xsl:for-each select="key('SearchMnn',$C1)">
				<xsl:variable name="C2" select="@code"/>
				<xsl:value-of select="@name"/>
			</xsl:for-each>
		</xsl:param>
		<xsl:value-of select="$C3"/>
	</xsl:template>
	<xsl:template name="foot4">
		<xsl:param name="C1"/>
		<xsl:param name="C3">
			<xsl:for-each select="key('SearchEx',$C1)">
				<xsl:variable name="C2" select="@code"/>
				<xsl:value-of select="@name"/>
			</xsl:for-each>
		</xsl:param>
		<xsl:value-of select="$C3"/>
	</xsl:template>
</xsl:stylesheet>
